#include "FloatValueTest.h"
#include <stdio.h>
#include <assert.h>
#include <string.h>

FloatValueTest::FloatValueTest()
{
}

void FloatValueTest::test()
{
    testValue(3, 0, "3");
    testValue(3, 1, "3.0");
    testValue(3, 5, "3.00000");
    testValue(3.123456789, 0, "3");
    testValue(3.123456789, 1, "3.1");
    testValue(3.123456789, 5, "3.12346");
    testValue(3.513456789, 1, "3.5");
    testValue(3.593456789, 1, "3.6");
}

void FloatValueTest::testValue(double number, uint8_t digits, const char *expected)
{
    printf("Expecting output '%s' for number %f with precision %d\n", expected, number, digits);
    FloatValue value(number, digits);
    assert(value.length() == strlen(expected));
    assert(value.valueType() == VALUE_FLOAT);
    assert(value.floatValue() == number);
    value.write(sink);
    assert(strcmp(expected, sink.value()) == 0);
    sink.clear();

    Value* copy = value.copy();
    assert(copy->floatValue() == value.floatValue());
    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    delete copy;
}

