#ifndef MOCKCLIENT_H
#define MOCKCLIENT_H

#include <stdint.h>
#include <AbstractClient.h>
#include "BufferedDataSource.h"
#include "BufferedDataSink.h"

#define CLIENT_OK 0
#define CLIENT_CONNECTION_ERROR 1
#define CLIENT_INTERNAL_ERROR 2

class MockClient : public AbstractClient
{
public:
    MockClient();

    void receiveData(const char* str);
    char* sentData();
    void clearSent();
    char* lastIdentifier();

    uint8_t beginRequest();
    uint8_t sendIdentifier(const char*);
    uint8_t sendData(DataGenerator& generator);
    uint8_t endRequest();
    uint8_t awaitResponse();
    AbstractDataSource& receiveData();
    void stop();
private:
    uint8_t _state;
    const char *_data;
    const char *_ident;
    BufferedDataSink _sink;
    BufferedDataSource _source;
};

#endif
