#include "SmartRestTest.h"
#include <string.h>
#include <assert.h>
#include <ComposedRecord.h>
#include <CharValue.h>
#include <IntegerValue.h>
#include <ParsedRecord.h>

SmartRestTest::SmartRestTest() : _smart("com_cumulocity_MockDevice")
{
}

void SmartRestTest::test()
{
    // will receive an "echo ok" message later on.
    _smart.client().receiveData("20,12345\r\n");

    {
        // prepare sending data generator
        IntegerValue v1(10);CharValue v2("This is me!");
        Value *varr[2] = {&v1, &v2};
        ComposedRecord record;
        record.add(v1).add(v2);

        // send data
        assert(_smart.send(record) == SMARTREST_SUCCESS);
        // make sure it 'got there'
        assert(strcmp("10,This is me!\r\n", _smart.client().sentData()) == 0);
    }

    {
        ParsedRecord record;
        assert(_smart.receive(record) == SMARTREST_SUCCESS);

        assert(record);
        assert(record.values() == 2);
        assert(record.value(0).integerValue() == 20);
        assert(record.value(1).integerValue() == 12345);

        assert(_smart.receive(record) == SMARTREST_END_OF_RESPONSE);
        assert(!record);
    }
}
