#include "ParsedValueTest.h"
#include <stdio.h>
#include <assert.h>
#include <string.h>

ParsedValueTest::ParsedValueTest()
{
}

void ParsedValueTest::test()
{
    testNull();
    testInteger("0", 0l);
    testInteger("-1", -1l);
    testInteger("1", 1l);
    testInteger("300", 300l);
    testInteger("-300", -300l);
    testInteger("30000000000", 30000000000l);
    testInteger("-30000000000", -30000000000l);
    testFloat("1.0", 1.0);
    testFloat(".1", 0.1);
    testFloat("-.1", -0.1);
    testFloat("-1.0", -1.0);
    testFloat("1.2345", 1.2345);
    testFloat("-1.2345", -1.2345);
    testFloat("12345.2345", 12345.2345);
    testFloat("-12345.2345", -12345.2345);
    testCharacter("Hello", "Hello");
    testCharacter("123123.", "123123.");
    testCharacter("-123123.", "-123123.");
    testCharacter("-", "-");
}

void ParsedValueTest::testNull()
{
    ParsedValue value("");
    assert(value.valueType() == VALUE_NULL);
    assert(value.characterValue() == NULL);
    assert(value.integerValue() == 0l);
    assert(value.floatValue() == 0.0);
    assert(value.length() == 0);
    value.write(sink);
    assert(strcmp(sink.value(), "") == 0);
    sink.clear();

    Value *copy = value.copy();
    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(copy->characterValue() == value.characterValue());
    delete copy;
}

void ParsedValueTest::testInteger(const char *string, long expected)
{
    ParsedValue value(string);
    assert(value.length() == strlen(string));
    assert(value.valueType() == VALUE_INTEGER);
    assert(value.integerValue() == expected);
    value.write(sink);
    assert(strcmp(string, sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();

    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(copy->integerValue() == value.integerValue());
    copy->write(sink);
    assert(strcmp(string, sink.value()) == 0);
    sink.clear();
    delete copy;
}

void ParsedValueTest::testFloat(const char *string, double expected)
{
    ParsedValue value(string);
    assert(value.length() == strlen(string));
    assert(value.valueType() == VALUE_FLOAT);
    assert(value.floatValue() == expected);
    value.write(sink);
    assert(strcmp(string, sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();

    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(copy->floatValue() == value.floatValue());
    copy->write(sink);
    assert(strcmp(string, sink.value()) == 0);
    sink.clear();
    delete copy;
}

void ParsedValueTest::testCharacter(const char *string, const char *expected)
{
    ParsedValue value(string);
    assert(value.length() == strlen(expected));
    assert(value.valueType() == VALUE_CHARACTER);
    assert(value.characterValue() == string);
    value.write(sink);
    assert(strcmp(expected, sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();

    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(strcmp(copy->characterValue(), value.characterValue()) == 0);
    assert(copy->characterValue() != value.characterValue());
    delete copy;
}

