#include "CharValueTest.h"
#include <stdio.h>
#include <assert.h>
#include <string.h>

CharValueTest::CharValueTest()
{
}

void CharValueTest::test()
{
    testValue("abc", "abc");
    testValue("hello world", "hello world");
    testValue("hello, world", "\"hello, world\"");
    testValue(" hello world", "\" hello world\"");
    testValue("hello world ", "\"hello world \"");
    testValue("hello\"world", "\"hello\"\"world\"");
    testValue("hello\"\"world", "\"hello\"\"\"\"world\"");
    testValue("hello\",world ", "\"hello\"\",world \"");
    testNull();
}

void CharValueTest::testValue(const char *string, const char *expected)
{
    printf("Expecting '%s' for value '%s'\n", expected, string);
    CharValue value(string);
    assert(value.length() == strlen(expected));
    assert(value.valueType() == VALUE_CHARACTER);
    assert(value.characterValue() == string);
    value.write(sink);
    assert(strcmp(expected, sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();

    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(strcmp(copy->characterValue(), value.characterValue()) == 0);
    assert(copy->characterValue() != value.characterValue());
    delete copy;
}

void CharValueTest::testNull()
{
    puts("Testing character null value.");

    CharValue value("");
    assert(value.length() == 0);
    assert(value.valueType() == VALUE_NULL);
    assert(value.characterValue() == NULL);
    value.write(sink);
    assert(strcmp("", sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();

    assert(copy->length() == value.length());
    assert(copy->valueType() == value.valueType());
    assert(copy->characterValue() == value.characterValue());
    delete copy;
}

