#ifndef BUFFEREDDATASOURCE_H
#define BUFFEREDDATASOURCE_H

#include <stddef.h>
#include <AbstractDataSource.h>

class BufferedDataSource : public AbstractDataSource
{
public:
    BufferedDataSource();

    void set(char *buf, size_t length);
    void set(const char *str);
    void clear();

    bool exhausted();
    char read();
    uint8_t status();

private:
    char *_data, *_ptr;
    size_t _length;
};

#endif
