/*
 * ParsedRecord.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef PARSEDRECORD_H
#define PARSEDRECORD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DataGenerator.h"
#include "Record.h"
#include "Value.h"

#ifndef PARSED_FIXED_SIZE
#define PARSED_FIXED_SIZE 24
#endif

class Parser;

/**
 * This value set collects values and serializes them.
 */
class ParsedRecord : public Record
{
public:
    ParsedRecord();
    ~ParsedRecord();

    size_t values() const;
    const Value& value(size_t index) const;

    DataGenerator* copy() const;

private:
    void set(const char*, size_t);

private:
    const Value *_values[PARSED_FIXED_SIZE];
    size_t _count;

friend class Parser;
};


#endif
