/*
 * ComposedRecord.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef COMPOSEDRECORD_H
#define COMPOSEDRECORD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DataGenerator.h"
#include "Record.h"
#include "Value.h"

#ifndef COMPOSED_INITIAL_CAPACITY
#define COMPOSED_INITIAL_CAPACITY 10
#endif
#ifndef COMPOSED_MEMORY_INCREMENT
#define COMPOSED_MEMORY_INCREMENT 5
#endif
//#define COMPOSED_FIXED_SIZE 25

/**
 * This value set collects values and serializes them.
 */
class ComposedRecord : public Record
{
public:
    ComposedRecord(bool=false);
    ~ComposedRecord();

    ComposedRecord& add(const Value&);
    void clear();

    size_t values() const;
    const Value& value(size_t index) const;

    DataGenerator* copy() const;

private:
    #ifndef COMPOSED_FIXED_SIZE
    const Value **_values;
    size_t _capacity;
    #else
    Value *_values[COMPOSED_FIXED_SIZE];
    #endif
    size_t _count;
    bool _alloc;
};

#endif
