/*
 * StaticData.cpp
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "StaticData.h"
#include <stdlib.h>
#include <string.h>

StaticData::StaticData(void* buffer, size_t length, bool copy)
{
    _alloc = copy;
    _len = length;
    if (copy) {
        _buf = malloc(length);
        memcpy(_buf, buffer, length);
    } else {
        _buf = buffer;
    }
}

StaticData::StaticData(const char* string, bool copy)
{
    _alloc = copy;
    if (copy) {
        _len = strlen(string)*sizeof(char);
        _buf = malloc(_len);
        memcpy(_buf, string, _len);
    } else {
        _buf = (void*)string;
        _len = strlen(string)*sizeof(char);
    }
}

StaticData::~StaticData()
{
    if (_alloc)
        free(_buf);
}

size_t StaticData::writeTo(AbstractDataSink& sink) const
{
    return sink.write((void*)_buf, _len*sizeof(char));
}

size_t StaticData::writtenLength() const
{
    return _len;
}

DataGenerator* StaticData::copy() const
{
    return new StaticData(_buf, _len, true);
}

