/*
 * IntegerValue.cpp
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "IntegerValue.h"

IntegerValue::IntegerValue(long number)
{
    _negative = (number < 0L);
    if (_negative)
        _number = -number;
    else
        _number = number;
}

uint8_t IntegerValue::valueType() const
{
    return VALUE_INTEGER;
}

long IntegerValue::integerValue() const
{
    return (_negative) ? -_number : _number;
}

double IntegerValue::floatValue() const
{
    return 0.0;
}

const char * IntegerValue::characterValue() const
{
    return 0;
}

size_t IntegerValue::write(AbstractDataSink& sink) const
{
    size_t n = 0;
    if (_negative)
        n += sink.write('-');
    n += sink.write(_number);
    return n;
}

size_t IntegerValue::length() const
{
    size_t l = 0;

    if (_negative)
        l++;

    unsigned long n = _number;

    do {
        n /= 10;
        l++;
    } while(n);
    return l;
}

Value* IntegerValue::copy() const
{
    long number;

    number = (_negative) ? -_number : _number;
    return new IntegerValue(number);
}

