/*
 * ParsedRecord.cpp
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "ParsedRecord.h"
#include "ComposedRecord.h"
#include "ParsedValue.h"
#include "NullValue.h"
#include <stdlib.h>
#include <string.h>

ParsedRecord::ParsedRecord()
{
    _count = 0;
}

ParsedRecord::~ParsedRecord()
{
    for (size_t n = 0; n < _count; n++)
        delete _values[n];
}

size_t ParsedRecord::values() const
{
    return _count;
}

const Value& ParsedRecord::value(size_t index) const
{
    if (index >= _count)
        return aNullValue;
    return *_values[index];
}

DataGenerator* ParsedRecord::copy() const
{
    ComposedRecord *copy = new ComposedRecord(true);
    for (size_t n = 0; n < _count; n++)
        copy->add(*_values[n]);
    return copy;
}

void ParsedRecord::set(const char *strs, size_t count)
{
    for (size_t n = 0; n < _count; n++)
        delete _values[n];
    
    if (count > PARSED_FIXED_SIZE)
        count = PARSED_FIXED_SIZE;
    _count = count;
    const char *ptr = strs;
    for (size_t n = 0; n < count; n++) {
        _values[n] = new ParsedValue(ptr, false);
        ptr += strlen(ptr) + 1;
    }
}
