/*
 * DataGenerator.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef DATAGENERATOR_H
#define DATAGENERATOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>
#include "AbstractDataSink.h"

/*
 * The DataGenerator class provides a way to stream data to a
 * connection..
 */
class DataGenerator
{
public:
    virtual ~DataGenerator()
    {
    }

    /**
     * Writes the object to the specified destination.
     * @param s the destination
     * @return the number of bytes written
     */
    virtual size_t writeTo(AbstractDataSink&) const = 0;

    /**
     * Returns the estimated number of bytes which will be written.
     * @return the estimated number of bytes printed
     */
    virtual size_t writtenLength() const = 0;

    /**
     * Creates a deep copy on the heap. The class type may be different.
     * The only thing guaranteed is that the copy behaves exactly
     * the same.
     * @return cloned object with no memory dependencies
     */
    virtual DataGenerator* copy() const = 0;
};

#endif
