#include "mbed.h"
#include "C027.h"
#include "UbloxUSBGSMModem.h"
#include "UbloxUSBCDMAModem.h"

#include "HTTPClient.h"

C027 c027;

void test(void const*)
{
    c027.mdmPower(true);
    UbloxUSBGSMModem modem; // for LISA-C use the UbloxUSBCDMAModem instead
    HTTPClient http;
    char str[512];

    int ret = modem.connect("internet"); // eventaully set another apn here
    if(ret)
    {
        printf("Could not connect %d\n", ret);
        return;
    }
    
    //GET data
    printf("Trying to fetch page...\n");
    ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret) {
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    //POST data
    HTTPMap map;
    HTTPText text(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("Trying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &text);
    if (!ret) {
        printf("Executed POST successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    modem.disconnect();
    c027.mdmPower(false);
    
    while(1) {
    }
}


int main()
{
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
