#include "MbedDataSource.h"
#include "stdio.h"

MbedDataSource::MbedDataSource(TCPSocketConnection& sock) : _sock(sock)
{
    _offset = _len = 0;
    _timeout = false;
}

MbedDataSource::~MbedDataSource()
{
}

char MbedDataSource::read()
{
    while (_offset == _len) {
        if (!receive())
            return 0;
    }
    
    return _buf[_offset++];
}

uint8_t MbedDataSource::status()
{
    if (!_sock.is_connected())
        return DS_STATUS_CLOSED;
    
    if (_timeout)
        return DS_STATUS_TIMEOUT;
    
    return DS_STATUS_OK;
}

bool MbedDataSource::receive()
{
    int ret;

    if (status() != DS_STATUS_OK)
        return false;
    
    _sock.set_blocking(true, 60000);
    ret = _sock.receive(_buf, MBED_SOURCE_BUFFER_SIZE);
    
    if (ret < 0) {
        _timeout = true;
        return false;
    }
    
    _len = (size_t)ret;
    _offset = 0;
    
    return true;
}

void MbedDataSource::reset()
{
    _len = _offset = 0;
    _timeout = false;
}