#ifndef MBEDDATASINK_H
#define MBEDDATASINK_H

#include <stddef.h>
#include "AbstractDataSink.h"
#include "TCPSocketConnection.h"

#define MBED_SINK_BUFFER_SIZE 60

class MbedClient;

class MbedDataSink : public AbstractDataSink
{
public:
    MbedDataSink(TCPSocketConnection& sock);
    ~MbedDataSink();
    
    size_t write(char c);
    size_t write(void *buf, size_t length);
    size_t write(const char *str);
    size_t write(unsigned long number);
    
    
protected:
    bool flush();
    bool send();
    void reset();

private:
    TCPSocketConnection& _sock;
    char _buf[MBED_SINK_BUFFER_SIZE];
    size_t _len;

friend class MbedClient;
};

#endif