#ifndef MBEDCLIENT_H
#define MBEDCLIENT_H

#include <stdint.h>
#include "AbstractClient.h"
#include "TCPSocketConnection.h"
#include "MbedDataSource.h"
#include "MbedDataSink.h"
#include "HTTPResponseFilter.h"

#define MBED_STATE_INIT 0
#define MBED_STATE_IN_REQUEST 1
#define MBED_STATE_SENT_ID 2
#define MBED_STATE_SENT_DATA 3
#define MBED_STATE_REQ_COMPLETE 4
#define MBED_STATE_RECVD_RESPONSE 5
#define MBED_STATE_RECV_DATA 6

class MbedClient : public AbstractClient {
public:
    MbedClient(const char*, uint16_t, const char*, const char*);
    ~MbedClient();

    uint8_t beginRequest();
    uint8_t sendIdentifier(const char*);
    uint8_t sendData(DataGenerator& generator);
    uint8_t endRequest();
    uint8_t awaitResponse();
    AbstractDataSource& receiveData();
    void stop();

protected:
    bool send(const char *str);
    bool sendBasicAuth();

private:
    const char *_host, *_username, *_password;
    uint16_t _port, _state;
    TCPSocketConnection _sock;
    MbedDataSource _source;
    MbedDataSink _sink;
    HTTPResponseFilter _filter;
};

#endif