#ifndef HTTPRESPONSEFILTER_H
#define HTTPRESPONSEFILTER_H

#include <stddef.h>
#include "AbstractDataSource.h"

#define RESPF_STATE_INIT 0
#define RESPF_STATE_READ_STATUS 1
#define RESPF_STATE_READ_HEADERS 2

/**
 * Reads and evaluates a HTTP response.
 * The read() and status() methods allow access to the response content
 * without HTTP headers.
 */
class HTTPResponseFilter : public AbstractDataSource
{
public:
    HTTPResponseFilter(AbstractDataSource& source);
    ~HTTPResponseFilter();
    
    char read();
    uint8_t status();

    uint16_t readStatus();
    bool skipHeaders();
    
    void reset();

private:
    AbstractDataSource& _source;
    uint8_t _state;
    size_t _length, _read;
};

#endif