#ifndef MBEDDATASOURCE_H
#define MBEDDATASOURCE_H

#include <stddef.h>
#include "AbstractDataSource.h"
#include "TCPSocketConnection.h"

#define MBED_SOURCE_BUFFER_SIZE 60

class MbedClient;

class MbedDataSource : public AbstractDataSource
{
public:
    MbedDataSource(TCPSocketConnection& sock);
    ~MbedDataSource();

    char read();
    uint8_t status();

protected:
    bool receive();
    void reset();

private:
    TCPSocketConnection& _sock;
    char _buf[MBED_SOURCE_BUFFER_SIZE];
    size_t _len, _offset;
    bool _timeout;

friend class MbedClient;
};

#endif
