#include "MbedDataSink.h"
#include "MbedClient.h"
#include <stdlib.h>
#include <string.h>

#include "mbed.h"

MbedDataSink::MbedDataSink(TCPSocketConnection& sock) : _len(0), _sock(sock)
{
}

MbedDataSink::~MbedDataSink()
{
}

size_t MbedDataSink::write(char c)
{
    while (MBED_SINK_BUFFER_SIZE - _len < 1) {
        if (!send())
            return 0;
    }
    
    _buf[_len++] = c;
    return 1;
}

size_t MbedDataSink::write(void *buf, size_t length)
{
    size_t sent = 0, len;
    
    while (sent < length) {
        while (MBED_SINK_BUFFER_SIZE - _len < 1) {
            if (!send())
                return 0;
        }
        
        if (MBED_SINK_BUFFER_SIZE - _len >= length-sent)
            len = length-sent;
        else
            len = MBED_SINK_BUFFER_SIZE - _len;
        
        memcpy(_buf+_len, (char*)buf+sent, len);
        _len += len;
        sent += len;
    }
    
    return length;
}

size_t MbedDataSink::write(const char *str)
{
    return write((void*)str, strlen(str));
}

size_t MbedDataSink::write(unsigned long number)
{
    char str[24];
    
    snprintf(str, 24, "%lu", number);
    return write(str);
}

bool MbedDataSink::flush()
{
    while (_len > 0) {
        if (!send())
            return false;
    }
    
    return true;
}

bool MbedDataSink::send()
{
    int ret;
    
    if (!_sock.is_connected())
        return false;

    _sock.set_blocking(true);
    ret = _sock.send(_buf, _len);
    
    //TODO: fix bug in u-blox so no longer wait is needed
    wait(0.5);
    
    if (ret < 0){
        puts("Send failed.");
        return false;
    }
    
    // move rest of buffer
    if ((ret > 0) && (ret < _len))
        memmove(_buf, _buf+ret, _len-ret);
    
    _len -= ret;
    return true;
}

void MbedDataSink::reset()
{
    _len = 0;
}