#ifndef COMMON_H
#define COMMON_H

#include <stdint.h>
#include <stddef.h>
#include "mbed.h"
#include "C027.h"
#include "MbedSmartRest.h"
#include "rtos.h"

#define CREDENTIALS_FILE "001_CREDENTIALS"
#define CREDENTIALS_BUFFER 256

#define A0  P0_23
#define A1  P0_24
#define A2  P0_25
#define A3  P0_26
#define A4  P0_30
#define A5  P1_31

#define D0  P4_29
#define D1  P4_28
#define D2  P2_13
#define D3  P2_0
#define D4  P2_12
#define D5  P2_1
#define D6  P2_2
#define D7  P2_11

#define D8  P2_4
#define D9  P2_3
#define D10 P1_21
#define D11 P1_24
#define D12 P1_23
#define D13 P1_20
    
#define SDA P0_0
#define SCL P0_1


/** signal quality type */
typedef struct
{
    int8_t rssi;  // RSSI in dBm
    uint8_t ber; // BER in %
} sigq_t;

typedef struct
{
    char username[128];
    char password[128];
} credentials_t;

extern C027 c027;
//extern UbloxUSBGSMModem modem;
extern MbedSmartRest client;

const char * imei();
const char * imsi();
const char * cellId();
const char * iccid();
sigq_t * signalQuality();
void credentials_set(credentials_t *dst, const char *tenant, const char *username, const char *password);
bool credentials_read(credentials_t *dst);
void credentials_write(credentials_t *src);
void credentials_reset();
int program(void);

#endif