#include "apndb.h"
#include "stdlib.h"
#include "stdio.h"
#include "string.h"

#define APNDB_COUNT 5

// Contains all tuples
apndb_t apndb[] = {
    { .mcc = "204", .mnc = "04", .carrier = "Vodafone NL", .apn = "public4.m2minternet.com" }
};

apndb_t * apndb_get(const char * imsi)
{
    char chr1[8], chr2[8];
    size_t len;
    
    for (size_t i = 0; i < APNDB_COUNT; i++) {
        strcpy(chr1, apndb[i].mcc);
        strcat(chr1, apndb[i].mnc);
        len = strlen(chr1);
        strncpy(chr2, imsi, len);
        chr2[len] = '\0';
        
        if (strcmp(chr1, chr2) == 0)
            return &apndb[i];
    }
    
    return NULL;
}
