#include "common.h"
#include "apndb.h"
#include "io.h"

C027 c027;
MDMSerial* pMdm;
sigq_t sigQ = {};
char cCellId[8+1];
MDMParser::DevStatus devStatus = {};
MDMParser::NetStatus netStatus = {};

int main()
{
    int ret; size_t c;
    
    puts("Hello");

    io_init();
    puts("IO initialized.");

    MDMSerial mdm;
    //mdm.setDebug(4);
    pMdm = &mdm;

    if (!mdm.init(NULL, &devStatus)) {
        puts("Modem initialization failed. Check your PIN number.");
        return 1;
    }

    puts("Searching for login...");
    apndb_t *apn = apndb_get(devStatus.imsi);
    if (apn == NULL) {
        puts("No APN found. Stop.");
        return 1;
    }
    
    // print out basic device data
    printf("IMEI: %s\n", devStatus.imei);
    printf("IMSI: %s\n", devStatus.imsi);

    if (!mdm.registerNet(&netStatus)) {
        puts("Network registration failed.");
        return 1;
    }

    printf("Carrier: %s\n", apn->carrier);
    puts("Joining Network.");
    if (mdm.join(apn->apn) == NOIP) {
        puts("Could not join network. Make sure chosen carrier is correct and no credentials are required.");
        return 1;
    }
    
    // Shown on display
    signalQuality();

    puts("Starting program...");    
    
    // restart program upon failure
    do {
        ret = program();
        if (ret)
            puts("Restarting program...");
    } while (ret);
    
    mdm.disconnect();
    c027.mdmPower(false);
    
    return 0;
}

const char * imei()
{
    return devStatus.imei;
}

const char * imsi()
{
    return devStatus.imsi;
}

const char * cellId()
{
    if (!pMdm->checkNetStatus(&netStatus))
        return NULL;

    if (snprintf(cCellId, sizeof(cCellId), "%X", netStatus.ci) < 1)
        return NULL;
        
    return cCellId;
}

const char * iccid()
{
    return devStatus.ccid;
}

sigq_t * signalQuality()
{
    sigQ.rssi = 0; sigQ.ber = 0;
    if (!pMdm->checkNetStatus(&netStatus))
        return NULL;

    sigQ.rssi = netStatus.rssi;
    sigQ.ber = netStatus.ber;
    
    lcd_signal(sigQ.rssi, sigQ.ber);
    return &sigQ;
}

void credentials_set(credentials_t *dst, const char *tenant, const char *username, const char *password)
{
    char *ptr = dst->username;
    
    strcpy(ptr, tenant);
    ptr += strlen(tenant);
    strcpy(ptr++, "/");
    strcpy(ptr, username);
    strcpy(dst->password, password);
}

bool credentials_read(credentials_t *dst)
{
    char buf[CREDENTIALS_BUFFER], *ptr;

    int res =  pMdm->readFile(CREDENTIALS_FILE, buf, CREDENTIALS_BUFFER);

    if (res < 0)
        return false;
        
    buf[res] = '\0';
    if ((ptr = strchr(buf, '\n')) == NULL)
        return false;
    *ptr = '\0';
    
    ptr = buf;
    strcpy(dst->username, ptr);
    ptr += strlen(ptr)+1;
    strcpy(dst->password, ptr);
    return true;
}

void credentials_write(credentials_t *src)
{
    char buf[CREDENTIALS_BUFFER], *ptr;
    size_t len;

    ptr = buf;
    len = strlen(src->username);
    strcpy(ptr, src->username);
    ptr += len;
    
    *ptr++ = '\n';
    len++;
    
    len += strlen(src->password);
    strcpy(ptr, src->password);
    
    pMdm->delFile(CREDENTIALS_FILE);
    pMdm->writeFile(CREDENTIALS_FILE, buf, len);
}

void credentials_reset()
{
    pMdm->delFile(CREDENTIALS_FILE);
}
