#include "io.h"
#include "rtos.h"
#include "mbed.h"

void timer_callback(void const*);
void lcd_update(void);

// Using Arduino pin notation
C12832 lcdDisplay(D11, D13, D12, D7, D10);
MMA7660 accSensor(SDA,SCL);
LM75B tempSensor(SDA,SCL);
DigitalOut button(D4);
AnalogIn meter0(A0);
AnalogIn meter1(A1);

RtosTimer *timer;

bool tempFound = false, accFound = false;
uint32_t count = 0;
bool btnPressed = false;

char cSignal[80] = "", cTenant[80] = "", cStatus[80] = "";

void io_init(void)
{
    timer = new RtosTimer(&timer_callback, osTimerPeriodic);
    timer->start(50);
    tempFound = tempSensor.open();
    accFound = accSensor.testConnection();
    
    if (!tempFound)
        puts("Temperature sensor not found.");
    if (!accFound)
        puts("Accelerometer not found.");
    
    lcd_update();
}

float temperature()
{
    if (!tempFound)
        return 0.0;

    return tempSensor.temp();
}

acceleration_t acceleration()
{
    float data[3];
    acceleration_t ret = { 0.0, 0.0, 0.0 };

    if (accFound) {
        accSensor.readData(data);
        ret.x = data[0];
        ret.y = data[1];
        ret.z = data[2];
    }

    return ret;
}

uint32_t counter()
{
    return count;
}

double potentiometer(uint8_t n)
{
    switch (n) {
        case 0: return (double)meter0;
        case 1: return (double)meter1;
        default: return 0.0;
    }
}

void lcd_signal(int8_t rssi, uint8_t ber)
{
    if ((rssi == 0) && (ber == 0))
        snprintf(cSignal, 80, "%s", "No signal");
    else
        snprintf(cSignal, 80, "RSSI: %d dBm  BER: %d %%", rssi, ber);
    lcd_update();
}

void lcd_tenant(const char* tenant)
{
    snprintf(cTenant, 80, "Tenant: %s", tenant);
    lcd_update();
}

void lcd_status(const char* status)
{
    snprintf(cStatus, 80, "%s", status);
    lcd_update();
}

void timer_callback(void const*)
{
    if ((!btnPressed) && (button))
        count++;
    btnPressed = button;
}

void lcd_update(void)
{
    lcdDisplay.cls();
    lcdDisplay.locate(0, 0);
    lcdDisplay.printf("%s\n%s\n%s\n", cSignal, cTenant, cStatus);
}
