#ifndef IO_H
#define IO_H

#include "common.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "C12832.h"

typedef struct
{
    float x, y, z;
} acceleration_t;

void io_init(void);
float temperature();
acceleration_t acceleration();
uint32_t counter();
double potentiometer(uint8_t n);
void lcd_signal(int8_t rssi, uint8_t ber);
void lcd_tenant(const char* tenant);
void lcd_status(const char* status);

#endif