#include "HTTPGeneratorWrapper.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

HTTPGeneratorWrapper::HTTPGeneratorWrapper(DataGenerator& generator) : _sink(generator.writtenLength())
{
    generator.writeTo(_sink);
    _len = _sink.length();
    _pos = 0;
    
    char *p = (char*)_sink.buffer();
    size_t i = 0;
    while (i < _len) {
        putchar(*p++);
        i++;
    }
}

void HTTPGeneratorWrapper::readReset()
{
    _pos = 0;
}

int HTTPGeneratorWrapper::read(char* buf, size_t len, size_t* pReadLen)
{
    *pReadLen = len;
    if (len > _len - _pos)
        *pReadLen = _len - _pos;
    else
        *pReadLen = len;
    memcpy(buf, _sink.buffer()+_pos, *pReadLen);
    _pos += *pReadLen;
    return 0;
}

int HTTPGeneratorWrapper::getDataType(char* type, size_t maxTypeLen)
{
    return 1;
}

bool HTTPGeneratorWrapper::getIsChunked()
{
    return false;
}

size_t HTTPGeneratorWrapper::getDataLen()
{
    return _len;
}
