#ifndef HTTPBUFFER_H
#define HTTPBUFFER_H

#include <stddef.h>
#include "IHTTPData.h"
#include "AbstractDataSource.h"

#define HTTPBUFFER_INITIAL_SIZE 128
#define HTTPBUFFER_INCREMENT 64
static int x = 123;
class HTTPBuffer : public IHTTPDataIn, public AbstractDataSource
{
public:
    HTTPBuffer();
    ~HTTPBuffer();

    char read();
    uint8_t status();
    
    void writeReset();

protected:
    int write(const char* buf, size_t len);
    void setDataType(const char* type);
    void setIsChunked(bool chunked);
    void setDataLen(size_t len);
    void bufferSize(size_t length);

//private:
public:
    // buffer, write and read pointers
    char *_buf, *_wptr, *_rptr;
    size_t _len;
};

#endif