#ifndef MBEDCLIENT_H
#define MBEDCLIENT_H

#include "AbstractClient.h"
#include "HTTPBuffer.h"
#include "HTTPGeneratorWrapper.h"
#include "HTTPClient.h"

class MbedClient : public AbstractClient {
public:
    MbedClient(const char*, const char*, const char*);
    ~MbedClient();

    uint8_t beginRequest();
    uint8_t sendIdentifier(const char*);
    uint8_t sendData(DataGenerator& generator);
    uint8_t endRequest();
    uint8_t awaitResponse();
    AbstractDataSource& receiveData();
    void stop();

private:
    const char *_url, *_username, *_password;
    HTTPClient _client;
    HTTPGeneratorWrapper *_generator;
    HTTPBuffer _buffer;
    uint8_t _state;
    const char *_headers[2];
};

#endif