#ifndef MBEDDATASINK_H
#define MBEDDATASINK_H

#include <stddef.h>
#include "AbstractDataSink.h"

class HTTPGeneratorWrapper;

class MbedDataSink : public AbstractDataSink
{
public:
    MbedDataSink(size_t length);
    ~MbedDataSink();
    
    size_t write(char c);
    size_t write(void *buf, size_t length);
    size_t write(const char *str);
    size_t write(unsigned long number);
    
protected:
    const char * buffer();
    size_t length();

private:
    char *_buf, *_ptr;
    size_t _len;

friend class HTTPGeneratorWrapper;
};

#endif