#include "mbed.h"
#include "C027.h"
#include "UbloxUSBGSMModem.h"

#include "HTTPClient.h"

C027 c027;

int main(void)
{
     c027.mdmWakeup();
     c027.mdmReset();
     c027.mdmPower(true);
    UbloxUSBGSMModem modem; // for LISA-C use the UbloxUSBCDMAModem instead
    HTTPClient http;
    char str[512];

    puts("Trying to connect to modem...");
    int ret = modem.connect("public4.m2minternet.com"); // eventaully set another apn here
    if(ret)
    {
        printf("Could not connect %d\n", ret);
        return;
    }
    
    //POST data
    HTTPText text(str, 512);
    // LONG AND SHORT REQUESTS
    HTTPText data("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
    //HTTPText data("23123123lala");
    printf("Trying to post data...\n");
    ret = http.post("http://nocore.info:8888/", data, &text);

    if (!ret) {
        printf("Executed POST successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    modem.disconnect();
    c027.mdmPower(false);
    
    return 0;
}
