#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"
#include<string>
#include "stringUtils.h"

#define SMALL_WAIT_MS 10
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128
#define VOLTAGE_SCALER 3.3f

AnalogIn pot1(MB_POT1);
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;

I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);

using namespace std;
char* subpim = "mbed-sample-sub";
char* pubpim = "mbed-sample-pub";
const char* hostname = "broker.hivemq.com";
int port = 1883;



void messageArrived(MQTT::MessageData& md)
{
    char buf[100];
    sprintf(buf, "V(POT1) = %1.2f\r\n", pot1*VOLTAGE_SCALER);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    client.publish(pubpim, message);
        MQTT::Message &message = md.message;
    printf("Browser message: %.*s \n", message.payloadlen, (char*)message.payload);
    myOLED.clearDisplay();
    myOLED.setTextCursor(0, 0);
    myOLED.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    myOLED.display();
    
}



int main()
{
    wifi = WiFiInterface::get_default_instance();
    
    printf("Connecting to %s \n",MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if(ret != 0){
        printf("Greska u povezivanju");
        return -1;
    }
    printf("Success\n");
    
    socket.open(wifi);
    socket.connect(hostname,port);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-11";

    client.connect(data);
    client.subscribe(subpim, MQTT::QOS0, messageArrived);
    
    

    
    
    
    myOLED.begin(); 
    i2c_obj.frequency(400000);
    
    myOLED.clearDisplay();
    myOLED.display();
    
    
    while(1) {
        thread_sleep_for(SMALL_WAIT_MS);
        client.yield(1000);
    }
}
