//biblioteke
#include "mbed.h"
//makroi
#define A PA_10
#define B PA_9
#define C PA_8
#define D PB_10
#define E PB_5
#define F PB_4
#define G PB_3
#define SEL1 PB_6
#define SEL2 PC_7
//promenjive
AnalogIn pot_frekvencija(PA_1);
AnalogIn pot_jacina(PA_0);
InterruptIn dugme(PC_9);
PwmOut buz(PA_11);
BusOut display (A,B,C,D,E,F,G);
BusOut select (SEL2,SEL1);
//deklaracije funkcija
void ispis(int);
void displej (int);
void ISR_prekid(void);
//main
void main()
{   
    float jacina;
    while(true)//poteniciometri
    {
    buz.period_us(pot_frekvencija.read()*250);
    buz.write(pot_jacina.read()*0.6);
    jacina=pot_jacina.read()*100;
    ispis(jacina);
    dugme.fall(&ISR_prekid);
    wait_ms(10); 
    }
}
void ISR_prekid()
{   
}
void ispis(int broj)//ispis na displeju
{
    int j = broj%10;
    int k = broj/10;
    if (k==0)
    {
        display = 0b1000000;
    }
    else
    {
        displej(k);
    }
    select = 0b01;
    wait_ms(11);
    displej(j);
    select = 0b10;
    wait_ms(1); 
    
}
void displej (int broj)//displej
{
    switch(broj)
    {
        case 0 : display=0b1000000;break;   
        case 1 : display=0b1111001;break;   
        case 2 : display=0b0100100;break;   
        case 3 : display=0b0110000;break;   
        case 4 : display=0b0011001;break;   
        case 5 : display=0b0010010;break;   
        case 6 : display=0b0000010;break;   
        case 7 : display=0b1111000;break;   
        case 8 : display=0b0000000;break;   
        case 9 : display=0b0010000;break;   
    
    }
}