#include "mbed.h"
#include "tft.h"

#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "Tahoma22x26.h"

#define PIN_MOSI D11
#define PIN_MISO D12
#define PIN_SCLK D13
#define PIN_DC   D4
#define PIN_RST  D3
#define PIN_CS   D2

#define PIN_SD_MOSI PC_12
#define PIN_SD_SCLK PC_10
#define PIN_SD_MISO PC_11
#define PIN_SD_CS PD_2

extern unsigned char p1[];  // the mbed logo graphic

TFT::TFT()
    : SPI_TFT_ILI9341(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS, PIN_RST, PIN_DC,"TFT")
    , m_cSD(PIN_SD_MOSI, PIN_SD_MISO, PIN_SD_SCLK, PIN_SD_CS, "sd")
{
    init();    
}

void TFT::init()
{
    set_orientation(3);
    background(Blue);     // set background to black
    foreground(White);    // set chars to white
    cls();                // clear the screen    
    
    set_font((unsigned char*)Tahoma22x26);
    locate(0,0);
}

void TFT::test()
{
    //first show the 4 directions
    set_orientation(0);
    background(Black);
    cls();

    set_font((unsigned char*) Arial12x12);
    locate(0,0);
    printf("  Hello Mbed 0");
    set_orientation(1);
    locate(0,0);
    printf("  Hello Mbed 1");
    set_orientation(2);
    locate(0,0);
    printf("  Hello Mbed 2");
    set_orientation(3);
    locate(0,0);
    printf("  Hello Mbed 3");
    set_orientation(3);
    set_font((unsigned char*) Arial24x23);
    locate(50,100);
    printf("TFT orientation");

    wait(5);        // wait two seconds

    // draw some graphics
    cls();
    set_font((unsigned char*) Arial24x23);
    locate(100,100);
    printf("Graphic");

    line(0,0,100,0,Green);
    line(0,0,0,200,Green);
    line(0,0,100,200,Green);

    rect(100,50,150,100,Red);
    fillrect(180,25,220,70,Blue);

    circle(80,150,33,White);
    fillcircle(160,190,20,Yellow);

    double s;

    for (int i=0; i<320; i++) {
        s =20 * sin((long double) i / 10 );
        pixel(i,100 + (int)s ,Red);
    }

 
    wait(5);        // wait two seconds

    // bigger text
    foreground(White);
    background(Blue);
    cls();
    set_font((unsigned char*) Arial24x23);
    locate(0,0);
    printf("Different Fonts :");

    set_font((unsigned char*) Neu42x35);
    locate(10,30);
    printf("Hello Mbed 1");
    set_font((unsigned char*) Arial24x23);
    locate(20,80);
    printf("Hello Mbed 2");
    set_font((unsigned char*) Arial12x12);
    locate(35,120);
    printf("Hello Mbed 3");
    wait(5);

    background(Black);
    cls();
    locate(10,10);
    printf("Graphic from Flash");
    
    // mbed logo
    // defined in graphics.c
    //__align(4)
    //unsigned char p1[18920] = {
    //0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ....
    // 
    Bitmap(90,90,172,55,p1);

    wait(5);
    cls();
    
    // to compare the speed of the internal file system and a SD-card
    locate(10,10);
    printf("Graphic from internal File System");
    locate(10,20);
    printf("open test.bmp");
    int err = BMP_16(1,50,"/local/test.bmp");
    if (err != 1) printf(" - Err: %d",err);
    
    locate(10,110);
    printf("Graphic from external SD-card");
    locate(10,120);
    BMP_16(1,140,"/sd/test.bmp");
    if (err != 1) printf(" - Err: %d",err);
    
    wait(5);
    init();
}
