#include "mbed.h"

#include "lcdadafruit.h"
#include "lcd2004.h"
#include "keyreaderadafruit.h"
#include "keyreadernull.h"
#include "RTclock.h"

#include "DateModule.h"
#include "TempModule.h"
#include "TimeModule.h"
#include "TitleModule.h"
#include "SyncModule.h"

#include "MenuManager.h"

int main()
{
    // Share the I2C across multiple devices
    I2C cI2C(I2C_SDA, I2C_SCL);    // D3, D6
    cI2C.frequency(400000);    // I2C can handle two different frequencies - switch to high speed if asked
        
    //LCDadafruit cLCD(cI2C);
    LCD2004 cLCD(cI2C);
    //KeyReaderNull cKeys(cI2C);
    KeyReaderAdafruit cKeys(cI2C);
    
    RTclock cClock(cI2C, 0x68 << 1, RTclock::eDS3231);

    // Spin up RTC
    cClock.mapTime();
        
    // Set up display modules    
    Module * aModules[] =
    {
        new TitleModule(cLCD,cClock),        
        new TempModule(cLCD,cI2C,0x18 << 1),
        new TimeModule(cLCD,cClock),
        new DateModule(cLCD,cClock),        
        new SyncModule(cLCD,cClock),
    };

    // Set up the menu manager
    // MenuManager cMenuManager(aModules,_countof(aModules),cLCD,cKeys,16,2);
    MenuManager cMenuManager(aModules,_countof(aModules),cLCD,cKeys);

    // Start menu manager loop    
    cMenuManager.loop();
}
