/*
This library is written to control 4 motors of the arduino motor shield L293D V1 (https://i0.wp.com/sribasu.com/wp-content/uploads/2015/11/adafruit-motor-shield-v1-connect-dc-and-servo-motors.jpg)
The code specificly control the 2 pwm pins of 2 L293D ICs and serial, clock, latch, enable pins of 74HC595 (shift register)

The library is purposely examined on board FRDM-KL25Z. However, an appropriate defining the pins in main.cpp will make it suitable for other boards too.
==This code is written by Vo Trieu Quang Nhi on 21-9-17== 


//~~example main.cpp~~
#include "mbed.h"
#include "DCMotorControl.h"

//The board is FRDM-KL25Z
//Using the user guide of this board and identify the pin control pwm1 pwm2 pwm3 pwm4 data clock latch enable (of motor shiled)
//Here it is PTD2, PTA12, PTC8, PTA5, PTA13, PTA4, PTD3, PTC9
Motor myMotor(PTD2, PTA12, PTC8, PTA5, PTA13, PTA4, PTD3, PTC9);

//The code below is a test to turn motor from terminant B to terminant A
//begin speed is 10% then 50% and 100% with 3 seconds delay with the previous speed 
int main(void)
{
    myMotor.Direction(0,1,0,1,0,1,0,1);
    int i = 10;
    myMotor.setSpeed(i,i,i,i);
    wait(3);
    i=50;
    myMotor.setSpeed(i,i,i,i);
    wait(3);
    i=100;
    myMotor.setSpeed(i,i,i,i);
}
//~~end example~~
*/

#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H

#include "mbed.h"

class Motor
{
public:
    Motor(PinName pwm1, PinName pwm2, PinName pwm3, PinName pwm4, PinName data_pin, PinName clock_pin, PinName latch_pin, PinName enable_pin);
    void Direction(int M1a, int M1b, int M2a, int M2b, int M3a, int M3b, int M4a, int M4b);
    void setSpeed(float percentage_M1, float percentage_M2, float percentage_M3, float percentage_M4);
private:
    PwmOut _pwm1;//pwm1
    PwmOut _pwm2;//pwm2
    PwmOut _pwm3;//pwm3
    PwmOut _pwm4;//pwm4
    
    DigitalOut _SERIALDATA;//serial data
    DigitalOut _CLOCK;//clock
    DigitalOut _LATCH;//latch
    DigitalOut _ENABLE;//enable, set low to be in duty
};

#endif