// --------------------------------------------------------------------------------------------------------
//
//  September 2018
//  Author: Valeria Toffoli, Rohan Gurav 
// --------------------------------------------------------------------------------------------------------
//
//  FFT.h
//
// --------------------------------------------------------------------------------------------------------
// 
//  This library provides all the functions necessary to obtain the FFT form an analog ADXL connected with   
//  EV-COG-AD3029 or EV-COG-AD4050 Board. 
//
//  Permission is hereby granted, free of charge, to any person obtaining
//  a copy of this software and associated documentation files (the
//  "Software"), to deal in the Software without restriction, including
//  without limitation the rights to use, copy, modify, merge, publish,
//  distribute, sublicense, and/or sell copies of the Software, and to
//  permit persons to whom the Software is furnished to do so, subject to
//  the following conditions:
//
//  The above copyright notice and this permission notice shall be
//  included in all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// --------------------------------------------------------------------------------------------------------


#ifndef FFT_H_
#define FFT_H_

class FFT
{
public: 
    // constructor 
    int log2(int N);
    int check(int n);
    int reverse(int N, int n);
    void order(complex<double>*  f1, int N);
    void transform(complex<double>*  f, int N);
    void fourier(complex<double>*  f, int N, double d);
    
private:    
    const static uint8_t MAX = 200; 
    const static double M_PI = 3.14159265358979323846;         // reset code 
    
};
 
#endif
