// --------------------------------------------------------------------------------------------------------
//
//  September 2018
//  Author: Valeria Toffoli, Rohan Gurav 
//
// --------------------------------------------------------------------------------------------------------
//
//  ADXL100x.h
//
// --------------------------------------------------------------------------------------------------------
// 
//  This library provides all the functions necessary to interface the ADXL355 with EV-COG-AD3029 or  
//  EV-COG-AD4050 Board. Functions for reads, writes,and scaling are included. 
//  This library may be used for the entire ADXL100x family of devices 
//  with some modification.
//
//  Permission is hereby granted, free of charge, to any person obtaining
//  a copy of this software and associated documentation files (the
//  "Software"), to deal in the Software without restriction, including
//  without limitation the rights to use, copy, modify, merge, publish,
//  distribute, sublicense, and/or sell copies of the Software, and to
//  permit persons to whom the Software is furnished to do so, subject to
//  the following conditions:
//
//  The above copyright notice and this permission notice shall be
//  included in all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// --------------------------------------------------------------------------------------------------------


#ifndef ADXL100x_H_
#define ADXL100x_H_

class ADXL100x
{
public: 
    float sens;         // sensitivity [g/V]    
    float fact;         // conversion factor [V/g] 
    float offset;       // offset [V] 
    int dyn;            // dynamic range [g]
    // -------------------------- //
    // FUNCTIONS                  //  
    // -------------------------- //
    // constructor 
    ADXL100x(PinName ST_pin, PinName STB_pin, PinName OR_pin, PinName Vout_pin, int device, double power);
    void standby();
    void wakeup();
    float standard_dev(int bit);
    void calibrate1g(float value_p1g, float value_n1g);
    bool selftest(int bit, double power);
    uint16_t scanx();
    float accelScale(uint16_t data, int bit);
    
private:
    DigitalOut st; DigitalOut stb;
    DigitalIn over;
    AnalogIn vout;
    
    
};
 
#endif