#include "mbed.h"
#include <math.h>
#include <inttypes.h>
#include "ADXRS290.h"

Serial pc(USBTX, USBRX);
 
ADXRS290 gyro(SPI0_CS2, SPI0_MOSI, SPI0_MISO, SPI0_SCLK);   // PMOD port
Timeout t_loop;



void meas() {
    gyro.rate_data = gyro.scan();
    float x =float(gyro.rate_data.rt_x)*0.005*0.1;
    float y =float(gyro.rate_data.rt_y)*0.005*0.1;
    float z =float(gyro.rate_data.rt_z)*0.005*0.1;
    pc.printf("°data = %f \t %f \t  %f \r\n", x , y , z);
}

int main(){
    pc.baud(9600);
    pc.printf("SPI ADXRS Demo\n");
    // device info
    pc.printf("GET device ID\n");
    uint8_t d; 
    d=gyro.read_reg(gyro.ADI_ID);
    pc.printf("AD id = %x \r\n",d);
    d=gyro.read_reg(gyro.MEMS_ID);
    pc.printf("MEMS id = %x \r\n",d);
    d=gyro.read_reg(gyro.DEV_ID);
    pc.printf("device id = %x \r\n",d);
    d=gyro.read_reg(gyro.REV_ID);
    pc.printf("revision id = %x \r\n",d);
    // device data 
    pc.printf("GET device data [x, y, z, t] \r\n");
    do {
           t_loop.attach(&meas, 0.1); // setup to call measurement function after 0.1 seconds
    } while(1);
}