#include <stdint.h>
#include "mbed.h"
#include "ADXRS290.h"

/** ----------------------------------- */
/** SPI - MAX 5MHZ                      */
/** ----------------------------------- */
ADXRS290::ADXRS290(PinName cs_pin, PinName MOSI, PinName MISO, PinName SCK): adxrs290(MOSI, MISO, SCK), cs(cs_pin)
{
    cs = 1;
    adxrs290.format(8,_SPI_MODE);
    adxrs290.lock();
}
void ADXRS290::frequency(int hz)
{
    adxrs290.frequency(hz);
}

/** ----------------------------------- */
/** Writes the reg register with data   */
/** ----------------------------------- */
void ADXRS290::write_reg(ADXRS290_register_t reg, uint8_t data){
    adxrs290.format(8, _SPI_MODE);
    cs = false;
    adxrs290.write(static_cast<uint8_t>(reg) | _WRITE_REG_CMD);
    adxrs290.write(data);
    cs = true;
}
/** ----------------------------------- */
/** Reads the reg register              */
/** ----------------------------------- */
uint8_t ADXRS290::read_reg(ADXRS290_register_t reg){
    uint8_t ret_val;
    adxrs290.format(8, _SPI_MODE);
    cs = false;
    adxrs290.write(static_cast<uint8_t>(reg) | _READ_REG_CMD);
    ret_val = adxrs290.write(_DUMMY_BYTE);
    cs = true;
    return ret_val;
}
uint16_t ADXRS290::read_reg_u16(ADXRS290_register_t reg){
    uint16_t ret_val = 0;
    adxrs290.format(8, _SPI_MODE);
    cs = false;
    adxrs290.write(static_cast<uint8_t>(reg) | _READ_REG_CMD);
    ret_val = adxrs290.write(_DUMMY_BYTE);
    ret_val = (ret_val) | (adxrs290.write(_DUMMY_BYTE)<<8);
    cs = true;
    return ret_val;
}
/** ----------------------------------- */
/** Sets the CTL registers              */
/** ----------------------------------- */    
void ADXRS290::set_power_ctl_reg(uint8_t data){
    write_reg(POWER_CTL, data);
    wait(0.1);
}
void ADXRS290::set_filter_ctl_reg(ADXRS290_filter_ctl_t hpf, ADXRS290_filter_ctl_t lpf){
    write_reg(FILTER, hpf|lpf);
}
void ADXRS290::set_sync(ADXRS290_dataready_ctl_t data){
    }
/** ----------------------------------- */
/** READ data registers              */
/** ----------------------------------- */ 
uint16_t ADXRS290::scanx(){    
    return read_reg_u16(DATAX0);
}
uint16_t ADXRS290::scany(){
    return read_reg_u16(DATAY0);
}
uint16_t ADXRS290::scant(){
    return read_reg_u16(TEMP0);
}    
ADXRS290::ADXRS290_rate_t ADXRS290::scan(){
    uint16_t datax, datay, dataz;
    ADXRS290_rate_t res;
    // multiple byte read procedure
    adxrs290.format(8, _SPI_MODE);
    cs = false;
    adxrs290.write(static_cast<uint8_t>(DATAX0) | _READ_REG_CMD);
    datax = adxrs290.write(_DUMMY_BYTE);
    datax = (datax) | (adxrs290.write(_DUMMY_BYTE)<<8);
    datay = adxrs290.write(_DUMMY_BYTE);
    datay = (datay) | (adxrs290.write(_DUMMY_BYTE)<<8);
    dataz = adxrs290.write(_DUMMY_BYTE);
    dataz = (dataz) | (adxrs290.write(_DUMMY_BYTE)<<8);
    cs = true;
    // 2s compl conversion
    if ((datax & 0x8000) == 0) {res.rt_x=float(datax);}
    else{res.rt_x=float((~(datax - 0x01)) & 0xffff) * -1;}
    if ((datay & 0x8000) == 0) {res.rt_y=float(datay);}
    else{res.rt_y=float((~(datay - 0x01)) & 0xffff) * -1;}
    if ((dataz & 0x8000) == 0) {res.rt_z=float(dataz);}
    else{res.rt_z=float((~(dataz - 0x01)) & 0xffff) * -1;}
    return res;
}