
#ifndef ADXRS453_H_
#define ADXRS453_H_

class ADXRS453
{
public: 
    #define  gyro_sens 0.0125; // 80 [LSB/°/s]   
    #define  t_sens 0.2;      // 5 [LSB/°C]  
    // -------------------------- //
    // REGISTERS                  // 
    // -------------------------- //
    typedef enum {
        RATE1 = 0x00,
        RATE0 = 0x01,
        TEMP1 = 0x02,
        TEMP0 = 0x03,
        LOCST1 = 0x04,
        LOCST0 = 0x05,
        HICST1 = 0x06,
        HICST0 = 0x07,
        QUAD1 = 0x08,
        QUAD0 = 0x09,
        FAULT1 = 0x0A,
        FAULT0 = 0x0B,
        PID1 = 0x0C,
        PID0 = 0x0D,
        SN3 = 0x0E,
        SN2 = 0x0F,
        SN1 = 0x10,
        SN0 = 0x11
    } ADXRS453_register_t;
    // -------------------------- //
    // OUTPUT DATA                //
    // -------------------------- //
    typedef struct  {
        float rt_x;
        float rt_y;
        float rt_z;
    } ADXRS453_rate_t;
    ADXRS453_rate_t rate_data;
    ADXRS453_rate_t selftest_data; 
    // -------------------------- //
    // FUNCTIONS                  //  
    // -------------------------- //
    // SPI configuration & constructor 
    ADXRS453(PinName cs_pin , PinName MOSI , PinName MISO , PinName SCK );
    void frequency(int hz);
    // SPI configuration & constructor 
    void write_reg(ADXRS453_register_t reg, uint16_t data);
    uint16_t read_reg(ADXRS453_register_t reg);
    // ADXRS X/T/SelfTest scanning methods   
    uint16_t scanx();
    uint16_t scant();
    uint16_t scanst();
    uint16_t fault();
    // 
    void st();
private:
    // SPI adxl355;                 ///< SPI instance of the ADXL
    SPI adxrs453; DigitalOut cs;
    const static uint8_t _DEVICE_AD = 0xR01;     // contect of DEVID_AD (only-read) register 
    const static uint8_t _DUMMY_BYTE = 0xAA;    // 10101010
    const static uint8_t _WRITE_REG_CMD = 0x40; // write register
    const static uint8_t _READ_REG_CMD = 0x80;  // read register
    const static uint8_t _SPI_MODE = 0;         // timing scheme
};
 
#endif