
#ifndef ADXRS290_H_
#define ADXRS290_H_

class ADXRS290
{
public: 
    #define  gyro_sens 0.005; // 200 [LSB/°/s]   
    #define  t_sens 0.1;      // 10 [LSB/°C]  
    // -------------------------- //
    // REGISTERS                  // 
    // -------------------------- //
    typedef enum {
        ADI_ID = 0x00,
        MEMS_ID = 0x01,
        DEV_ID = 0x02,
        REV_ID = 0x03,
        SN0 = 0x04,
        SN1 = 0x05,
        SN2 = 0x06,
        SN3 = 0x07,
        DATAX0 = 0x08,
        DATAX1 = 0x09,
        DATAY0 = 0x0A,
        DATAY1 = 0x0B,
        TEMP0 = 0x0C,
        TEMP1 = 0x0D,
        POWER_CTL = 0x10,
        FILTER = 0x11,
        DATA_READY = 0x12
    } ADXRS290_register_t;
    // -------------------------- //
    // REGISTERS - DEFAULT VALUES //
    // -------------------------- //
    // Modes - POWER_CTL  
    typedef enum {
        TEMP_ON = 0x00,
        TEMP_OFF = 0x01,
        STANDBY = 0x00,
        MEASUREMENT = 0x02
    } ADXL355_modes_t;    
    // High-Pass and Low-Pass Filter - FILTER 
    typedef enum {
        LPF480 = 0x00,
        LPF320 = 0x01,
        LPF160 = 0x02,
        LPF80 = 0x03,
        LPF56 = 0x04,
        LPF40 = 0x05,
        LPF28 = 0x06,
        LPF20 = 0x07,
        HPFOFF = 0x00,
        HPF001 = 0x10,
        HPF002 = 0x20,
        HPF004 = 0x30,
        HPF008 = 0x40,
        HPF017 = 0x50,
        HPF035 = 0x60,
        HPF070 = 0x70,
        HPF140 = 0x80,
        HPF280 = 0x90,
        HPF1130 = 0xA0
    } ADXRS290_filter_ctl_t;
    // External timing register - INT_MAP 
    typedef enum {
        OVR_EN = 0x04,
        FULL_EN = 0x02,
        RDY_EN = 0x01
    } ADXRS290_intmap_ctl_t;
    // External timing register - SYNC 
    typedef enum {
        ANAL_SYNC = 0x00,
        DIGI_SYNC = 0x01
    } ADXRS290_dataready_ctl_t;
    // -------------------------- //
    // OUTPUT DATA                //
    // -------------------------- //
    typedef struct  {
        float rt_x;
        float rt_y;
        float rt_z;
    } ADXRS290_rate_t;
    ADXRS290_rate_t rate_data; 
    // -------------------------- //
    // FUNCTIONS                  //  
    // -------------------------- //
    // SPI configuration & constructor 
    ADXRS290(PinName cs_pin , PinName MOSI , PinName MISO , PinName SCK );
    void frequency(int hz);
    // SPI configuration & constructor 
    void write_reg(ADXRS290_register_t reg, uint8_t data);
    uint8_t read_reg(ADXRS290_register_t reg);
    uint16_t read_reg_u16(ADXRS290_register_t reg);
    // ADXRS general register R/W methods 
    void set_power_ctl_reg(uint8_t data);
    void set_filter_ctl_reg(ADXRS290_filter_ctl_t hpf, ADXRS290_filter_ctl_t odr);
    void set_sync(ADXRS290_dataready_ctl_t data);
    // ADXRS X/Y/T scanning methods   
    uint16_t scanx();
    uint16_t scany();
    uint16_t scant();
    ADXRS290_rate_t scan();
private:
    // SPI adxl355;                 ///< SPI instance of the ADXL
    Timeout conv_time;
    SPI adxrs290; DigitalOut cs;
    const static uint8_t _DEVICE_AD = 0x92;     // contect of DEVID_AD (only-read) register 
    const static uint8_t _DUMMY_BYTE = 0xAA;    // 10101010
    const static uint8_t _WRITE_REG_CMD = 0x00; // write register
    const static uint8_t _READ_REG_CMD = 0x80;  // read register
    const static uint8_t _SPI_MODE = 4;         // timing scheme
};
 
#endif