#include "mbed.h"
#include <inttypes.h>
#include "ADXL355.h"
 
Serial pc(USBTX, USBRX);
 
ADXL355 accl(SPI1_CS0, SPI1_MOSI, SPI1_MISO, SPI1_SCLK); // PMOD port
 
int main(){
    pc.baud(9600);
    pc.printf("SPI ADXL355 and ADXL357 Demo\n");
    pc.printf("GET device ID\n");
    accl.reset();
    uint8_t d; 
        d=accl.read_reg(accl.DEVID_AD);
        pc.printf("AD id = %x \r\n",d);
        d=accl.read_reg(accl.DEVID_MST);
        pc.printf("MEMS id = %x \r\n",d);
        d=accl.read_reg(accl.PARTID);
        pc.printf("device id = %x \r\n",d);
        d=accl.read_reg(accl.REVID);
        pc.printf("revision id = %x \r\n",d);
    pc.printf("GET device data [x, y, z, t] \r\n");
    accl.set_power_ctl_reg(accl.MEASUREMENT);
    d=accl.read_reg(accl.POWER_CTL);
    pc.printf("power control on measurement mode = %x \r\n",d);
    uint32_t x,y,z;
    uint16_t t;
    while(1) {
        x = accl.scanx();
        y = accl.scany();
        z = accl.scanz();
        t = accl.scant();
        pc.printf("%u \t %u \t %u \t %u \r\n" , x,y,z,t);
        wait(1.0);
  }
}
 
