#include <stdint.h>
#include "mbed.h"
#include "ADXL355.h"


//DigitalOut(cs);                  ///< DigitalOut instance for the chipselect of the ADXL
//DigitalOut int1;                ///< DigitalOut instance for the chipselect of the ADXL
//DigitalOut int2;                ///< DigitalOut instance for the chipselect of the ADXL

ADXL355::ADXL355(PinName cs_pin, PinName MOSI, PinName MISO, PinName SCK): adxl355(MOSI, MISO, SCK), cs(cs_pin)
{
    cs = 1;
    adxl355.format(8,_SPI_MODE);
    adxl355.lock();
}

/** SPI bus frequency   */
void ADXL355::frequency(int hz)
{
    adxl355.frequency(hz);
}

/**  Software resets    */
void ADXL355::reset(void)
{
    adxl355.format(8, _SPI_MODE);
    cs = false;
    // Writing Code 0x52 (representing the letter, R, in ASCII or unicode) to this register immediately resets the ADXL362.
    write_reg(RESET, _RESET);
    cs = true;
}
/** ----------------------------------- */
/** Writes the reg register with data   */
/** ----------------------------------- */
void ADXL355::write_reg(ADXL355_register_t reg, uint8_t data)
{
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(static_cast<uint8_t>(reg<<1) | _WRITE_REG_CMD);
    adxl355.write(data);
    cs = true;
}
void ADXL355::write_reg_u16(ADXL355_register_t reg, uint16_t data)
{
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(static_cast<uint8_t>(reg<<1) | _WRITE_REG_CMD);
    adxl355.write(static_cast<uint8_t>(data & 0xff));
    adxl355.write(static_cast<uint8_t>((data & 0xff00) >> 8));
    cs = true;
}
/** ----------------------------------- */
/** Reads the reg register              */
/** ----------------------------------- */
uint8_t ADXL355::read_reg(ADXL355_register_t reg)
{
    uint8_t ret_val;
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(static_cast<uint8_t>(reg<<1) | _READ_REG_CMD);
    ret_val = adxl355.write(_DUMMY_BYTE);
    cs = true;
    return ret_val;
}
uint16_t ADXL355::read_reg_u16(ADXL355_register_t reg){
    uint16_t ret_val = 0;
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(static_cast<uint8_t>(reg<<1) | _READ_REG_CMD);
    ret_val = adxl355.write(_DUMMY_BYTE);
    ret_val = (ret_val<<8) | adxl355.write(_DUMMY_BYTE);
    cs = true;
    return ret_val;
}
uint32_t ADXL355::read_reg_u32(ADXL355_register_t reg){
    uint32_t ret_val = 0;
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write((reg<<1) | _READ_REG_CMD);
    ret_val = adxl355.write(_DUMMY_BYTE);
    ret_val = (ret_val<<8) | adxl355.write(_DUMMY_BYTE);
    ret_val = (ret_val<<8) | adxl355.write(_DUMMY_BYTE);
    cs = true;
    return ret_val;
}
/** ----------------------------------- */
/** Sets the CTL registers              */
/** ----------------------------------- */
void ADXL355::set_power_ctl_reg(uint8_t data){
     write_reg(POWER_CTL, data);
}
void ADXL355::set_filter_ctl_reg(ADXL355_filter_ctl_t hpf, ADXL355_filter_ctl_t odr){
    write_reg(FILTER, static_cast<uint8_t>(hpf|odr));
}
void ADXL355::set_clk(ADXL355_sync_ctl_t data) {
    write_reg(SYNC, static_cast<uint8_t>(data));
}
void ADXL355::set_device(ADXL355_range_ctl_t range) {
    write_reg(RANGE, static_cast<uint8_t>(range));
}
/** ----------------------------------- */
/** Read the STATUS registers           */
/** ----------------------------------- */
uint8_t ADXL355::read_status(){
    return read_reg(STATUS);
}
/** ----------------------------------- */
/** ADXL must be set in measurement     */
/** mode to read the data registers     */
/** ----------------------------------- */
uint32_t ADXL355::scanx(){
    return read_reg_u32(XDATA3);
}
uint32_t ADXL355::scany(){
    return read_reg_u32(YDATA3);
}
uint32_t ADXL355::scanz(){
    return read_reg_u32(ZDATA3);
}
uint16_t ADXL355::scant(){
    return read_reg_u16(TEMP2);
}
/** ----------------------------------- */
/** ----------------------------------- */
void ADXL355::set_activity_axis(ADXL355_act_ctl_t axis) {}
void ADXL355::set_activity_cnt(uint8_t count) {}
void ADXL355::set_activity_threshold(uint8_t data_h, uint8_t data_l) {
    uint16_t ret_val = static_cast<uint16_t>((data_h<<8)|data_l);
    write_reg_u16(ACT_THRESH_H, ret_val);
}
void ADXL355::set_inactivity() {}
/** ----------------------------------- */
/** ----------------------------------- */
void ADXL355::set_interrupt1_pin(PinName in, ADXL355_intmap_ctl_t mode) {}
void ADXL355::set_interrupt2_pin(PinName in, ADXL355_intmap_ctl_t mode) {}
void ADXL355::enable_interrupt1() {}
void ADXL355::enable_interrupt2() {}
void ADXL355::disable_interrupt1() {}
void ADXL355::disable_interrupt2() {}
void ADXL355::set_polling_interrupt1_pin(uint8_t data) {}
void ADXL355::set_polling_interrupt2_pin(uint8_t data) {}
bool get_int1() {}
bool get_int2() {}
/** ----------------------------------- */
/** FIFO set up and read operation      */
/** ----------------------------------- */
uint8_t ADXL355::fifo_read_nr_of_entries(){
    return read_reg(FIFO_ENTRIES);
}
void ADXL355::fifo_setup(uint8_t nr_of_entries){
    if (nr_of_entries > 0x60) {
        nr_of_entries = nr_of_entries;
    }
    write_reg(FIFO_SAMPLES, nr_of_entries);
}    
uint32_t ADXL355::fifo_read_u32() {
    uint32_t ret_val = 0;
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(_READ_FIFO_CMD);
    ret_val = adxl355.write(_DUMMY_BYTE);
    ret_val = (ret_val<<8) | static_cast<uint8_t>(adxl355.write(_DUMMY_BYTE));
    ret_val = (ret_val<<4) | static_cast<uint8_t>(adxl355.write(_DUMMY_BYTE)>>4);
    cs = true;
    return ret_val;
    }
uint64_t ADXL355::fifo_scan() {
    uint64_t ret_val = 0;
    uint32_t x = 0, y = 0, z = 0, dummy;
    adxl355.format(8, _SPI_MODE);
    cs = false;
    adxl355.write(_READ_FIFO_CMD);
    for(uint8_t i = 0; i < 3; i++) {
        dummy = adxl355.write(_DUMMY_BYTE);
        dummy = (dummy<<8) | static_cast<uint8_t>(adxl355.write(_DUMMY_BYTE));
        dummy = (dummy<<4) | static_cast<uint8_t>(adxl355.write(_DUMMY_BYTE)>>4);
        dummy = dummy & 0xffff;
        switch(i) {
            case 0: // x
                x = dummy;
                break;
            case 1: // y
                y = dummy;
                break;
            case 2: // z
                z = dummy;
                break;
        }
    } 
    cs = true;
    // format (24)xx(24)yy(24)zz
    ret_val = static_cast<uint64_t> (x) << 48;
    ret_val |= static_cast<uint64_t>(y) << 24;
    ret_val |= static_cast<uint64_t>(z) ;
    return ret_val;
    }