
#ifndef CALIBRATION_H_
#define CALIBRATION_H_

class CALIBRATION
{
public: 
    // -------------------------- //
    // CONST AND VARIABLES        // 
    // -------------------------- //
    typedef struct {
        // sensitivity - we do not consider cross sensitivity
        float S[3]; 
        // temperature sensitivity 
        float St[3];
        // 0g offset
        float B[3];
    } calib_data_t;
    calib_data_t  adxl355_sensitivity;
    calib_data_t  adxl357_sensitivity;
    // -------------------------- //
    // FUNCTIONS                  //  
    // -------------------------- //
    
    calib_data_t convert_2p_all(float angle[1], float meas[1][2]);
            // angle = | angle1 angle2| in RAD
            // meas =  | ax1    ay1     az1 |
            //         | ax2    ay2     az2 |
    void convert_2p(float meas[1], int axis);
            // angle = | angle1 angle2| in RAD
            // meas =  | x1     x2 |
    void convert_4p(float meas[3], int axis);
            // for each axis
            // angle = | anglex1 anglex2 angley3 angley4|
            // meas =  | x1     x2      x3      x4 |
    
    float matrix_determinant(float a[12][12], float k);    
    void matrix_reset();
private:
};
 
#endif