#include <stdint.h>
#include <stdio.h>
#include <math.h>

#include "mbed.h"
#include "CALIBRATION.h"


#define PI 3.14159265

CALIBRATION::calib_data_t CALIBRATION::convert_2p_all(float angle[1], float meas[1][2]){
            // angle = | angle1 angle2| in RAD - 1/sqrt(3)*g 
            // meas =  | ax1    ay1     az1 |
            //         | ax2    ay2     az2 |
    calib_data_t  res;
    angle[1]=sin(angle[1]);
    angle[0]=sin(angle[0]);
    for(int i=0; i<3; i++){ 
        res.S[i]= (angle[1]-angle[0])/(meas[i][1]-meas[i][0]);
        res.B[i]= (angle[0]*meas[i][1]-angle[1]*meas[i][0])/(meas[i][1]-meas[i][0]);
    }
    return res;
}

void CALIBRATION::convert_4p(float meas[3], int axis){
            // https://www.eetimes.com/document.asp?doc_id=1274067&page_number=3
            // for each axis
            // angle = | anglex1-0° anglex2-90° angley3-180° angley4-270°|
            // meas =  | x1     x2      x3      x4 |
    float m, b;
    m = (meas[1]-meas[3])/2;
    b = (meas[0]-meas[3])/2;
    adxl355_sensitivity.S[axis] = adxl355_sensitivity.S[axis]/m;
    adxl355_sensitivity.B[axis] = adxl355_sensitivity.B[axis]-b;
}  
         
void CALIBRATION::convert_2p(float meas[1], int axis){
            // angle = | anglex1-0° anglex2-180°| = | anglex1@1g anglex2@-1g| in DEGREE
            // meas =  | x1     x2|
    float m, b;
    m = 2/(meas[0]-meas[1]);
    b = -(meas[0]+meas[1])/(meas[0]-meas[1]);
    adxl355_sensitivity.S[axis] = adxl355_sensitivity.S[axis]/m;
    adxl355_sensitivity.B[axis] = adxl355_sensitivity.B[axis]-b;
}

//CALIBRATION::calib_data_t CALIBRATION::convert_12p(float angle[11][2], float meas[11][2], int size){}


/*For calculating Determinant of the Matrix */

void CALIBRATION::matrix_reset(){
    // default values 
    adxl355_sensitivity.S[0] = 3.9e-6;
    adxl355_sensitivity.S[1] = 3.9e-6;
    adxl355_sensitivity.S[2] = 3.9e-6;
    adxl355_sensitivity.B[0] = 0;
    adxl355_sensitivity.B[1] = 0;
    adxl355_sensitivity.B[2] = 0;
    adxl355_sensitivity.St[0] = 0.02e-6;
    adxl355_sensitivity.St[1] = 0.02e-6;
    adxl355_sensitivity.St[2] = 0.02e-6;
    }



//https://www.sanfoundry.com/c-program-find-inverse-matrix/

//http://www.ccodechamp.com/c-program-to-find-inverse-of-matrix/