/**
* @brief        Main loop: XBee protocol handler
* @author       Supachai Vorapojpisut,Vissarut Prakobpon , Natanich Bunsila
* @date         May 8, 2017
*/

#include "mbed.h"
#include "platform.h"


RawSerial pc(USBTX, USBRX);  // use USB-serial for testing purpose
Mail<char, 2> mbx;  // use Mail API to forward data
Thread sensorThread;
Thread ledThread;


/**
* @brief        ISR code: reception of XBee API frame
*/
void rxHandler()
{
    char *mail = mbx.alloc();
    *mail = pc.getc();
    mbx.put(mail);
}


/**
* @brief        Main code: initial serial RX handler, then wait for detected frame
*/
int main()
{
    ledThread.start(led1_thread);
    sensorThread.start(sensorIn);
    pc.attach(rxHandler);
    while (true) {
        osEvent evt = mbx.get();
        if (evt.status == osEventMail) {
            char *mail = (char*)evt.value.p;
            pc.printf("Got %c\n", *mail);
            mbx.free(mail);
        }
    }
}

