
#ifndef GAME_STATE_H
#define GAME_STATE_H

#include "mbed.h"
#include "stdint.h"
#include "MbedJSONValue.h"
#include "graphics.h" 
#include <string>  

struct Coord {
    int8_t x; 
    int8_t y;
};

class Graphics; 

class GameState {
    private: 
        Coord p1_loc; 
        Coord p2_loc; 
        Coord ball_loc; 
        char is_done; 
        char has_started; 
        char localPlayerNum; 
        char lobbyHash[21]; 
        int countdown; 
        int score[2]; 
    public:
        GameState();
        Coord getPlayerOneLocation(); 
        Coord getPlayerTwoLocation(); 
        Coord getPlayerLocation(char player);   
        Coord getBallLocation();
        char *getLobbyHash();
        char getLocalPlayerNum(); 
        char hasStarted();
        char done();   
        int getCountdown();
        int getPlayerOneScore();
        int getPlayerTwoScore();
        int getPlayerScore(int player); 
        void setCountdown(int val);
        void updateAndRender(MbedJSONValue *serverResponse, Graphics *gfx);
};

#endif // GAME_STATE_H