#include "mbed.h"

// Function prototype/forward declaration for ISR.
void atint(void);
 
/** EINT3_IRQHandler
 */
extern "C" void PORTA_IRQHandler  (void) {
 
    // The "event" is connected to pin p10 which is LPC1768 P0_1
    // so lets trap that and ignore all other GPIO interrupts.    
    // Test for IRQ on Port0.
    if (PORTA->ISFR & (1<<5)) 
    {
        // If P0_1/p10 rises, call atint()
        atint();
    }
 
    // Clear this and all other possible GPIO generated interrupts as they don't concern us. 
    PORTA->ISFR = 0x0000FFFF;   
    //LPC_GPIOINT->IO2IntClr = (LPC_GPIOINT->IO2IntStatR | LPC_GPIOINT->IO2IntStatF);
    //LPC_GPIOINT->IO0IntClr = (LPC_GPIOINT->IO0IntStatR | LPC_GPIOINT>IO0IntStatF);
}
 
void event_irq_init(void) {
    // Use macro to set p10 as an input.
    //p10_AS_INPUT; 
    PORTA->PCR[5] = (PORTA->PCR[5] & ~PORT_PCR_MUX_MASK) | PORT_PCR_MUX(1);
    // Enable P0_1/p10 for rising edge interrupt generation.
    PORTA->PCR[5] = (PORTA->PCR[5] & ~PORT_PCR_IRQC_MASK) | PORT_PCR_IRQC(0xB);
   
    //LPC_GPIOINT->IO0IntEnR |= (1UL << 1);
    // Enable the interrupt.
    NVIC_EnableIRQ(PORTA_IRQn);
}


int main(void)
{
    event_irq_init();
    while(1)
    {
        static volatile int i;
        i++;
    }
}

void atint(void) {
    static int toggle = 0;
    DigitalOut rled(LED_RED);
    rled = toggle;
    toggle = !toggle;
}
