#include "mbed.h"

DigitalOut gpo(PTD7);
DigitalOut led(LED_RED);

InterruptIn trig(PTD1);
Timer trigtimer;
Timeout output_timeout;
Timeout input_timeout;


typedef enum {TRIG_DETECT_IDLE, TRIG_LOW, TRIG_FIRST_HIGH} trig_enum_t;
typedef enum {TRIG_EVENT_RISING, TRIG_EVENT_FALLING, TRIG_EVENT_TIMEOUT} trig_event_t;

trig_enum_t trigger = TRIG_DETECT_IDLE;

//Function declarations
void input_timeout_handler(void);
void get_new_state(trig_enum_t * trig, trig_event_t event);
void set_output(void);
void trig_rise_event(void);
void trig_fall_event(void);



void input_timeout_handler(void)
{
    get_new_state(&trigger, TRIG_EVENT_TIMEOUT);
}

void get_new_state(trig_enum_t * trig, trig_event_t event)
{
    const int jitter = 8;
    switch(*trig)
    {
    case TRIG_DETECT_IDLE:
    {
        if(event == TRIG_EVENT_FALLING)
        {
            *trig = TRIG_LOW;
            trigtimer.reset();
        }
        else // should not happen
            *trig = TRIG_DETECT_IDLE;
        break;
    }
    case TRIG_LOW:
    {
        if(event == TRIG_EVENT_RISING)
        {
            if(trigtimer.read_us() > (30 - jitter) && trigtimer.read_us() < (30+jitter) ) //if first low period detected
            {
                *trig = TRIG_FIRST_HIGH;
                input_timeout.attach_us(input_timeout_handler, 60);
            }
            else //pulse too short or too long
                *trig = TRIG_DETECT_IDLE;      
        }
        
        else // should not happen
            *trig = TRIG_DETECT_IDLE;
        break;
    }
    case TRIG_FIRST_HIGH:
    {
        led=!led;
        if(event == TRIG_EVENT_TIMEOUT)
        {
           gpo.write(0);
           output_timeout.attach_us(set_output, 1000);
           *trig = TRIG_DETECT_IDLE;
        }
        
        else // should not happen, maybe falling edge due to TOP684
        {
            *trig = TRIG_DETECT_IDLE;
            input_timeout.detach();
        }
        break;
    } 
    default:
        break;
    }
        
}
     

void set_output(void)
{
    gpo.write(1);
}


void trig_rise_event(void)
{
     get_new_state(&trigger, TRIG_EVENT_RISING);
}


void trig_fall_event(void)
{
    get_new_state(&trigger, TRIG_EVENT_FALLING);

}    

int main()
{
    trigtimer.start();
    trig.rise(trig_rise_event);
    trig.fall(trig_fall_event);
    while (true) {
        //gpo = !gpo; // toggle pin
        //led = !led; // toggle led
        wait(0.2f);
    }
}