#include "mbed.h"
#include "TSISensor.h"

DigitalInOut click(PTE20);
TSISensor tsi;
int  beeper_on = 0, pressed = 0;
uint16_t value_now, value_prev;
PwmOut rled(LED_RED);

void beeper(void)
{
    static uint8_t toggle = 0;
    if(toggle)
        toggle = 0;
    else
        toggle = 1;
    if(beeper_on)
        click = toggle;   
}

void read_sensor(void)
{
   value_prev = value_now;
   if(!beeper_on)
      value_now = tsi.readValue(2);
   if((value_now-2)> value_prev)
      pressed  = 1;
    
}

void led_off(void)
{
   rled = 1;
}

void do_beep(void)
{
    click.output();
    beeper_on = 1;
    wait(0.1);
    beeper_on = 0;
    click.input();
}
    
int main() {   
    Ticker beep;
    Ticker read;
    beep.attach(beeper,0.00025);
    read.attach(read_sensor,0.1);
    Timeout timeout;
    rled = 1;
    while(1) {
        if(pressed)
        {
            pressed = 0;
            rled = 0.5;
            timeout.detach();
            timeout.attach(led_off,0.5);
            do_beep();
        }
    }
}
//PTB0 - > ELECTRODE3 -> TSI_CH0