/*
 * SOES Simple Open EtherCAT Slave
 *
 * File    : cpuinit.h
 * Version : 0.9.2
 * Date    : 22-02-2010
 * Copyright (C) 2007-2010 Arthur Ketels
 *
 * SOES is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * SOES is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * As a special exception, if other files instantiate templates or use macros
 * or inline functions from this file, or you compile this file and link it
 * with other works to produce a work based on this file, this file does not
 * by itself cause the resulting work to be covered by the GNU General Public
 * License. However the source code for this file must still be made available
 * in accordance with section (3) of the GNU General Public License.
 *
 * This exception does not invalidate any other reasons why a work based on
 * this file might be covered by the GNU General Public License.
 *
 * The EtherCAT Technology, the trade name and logo "EtherCAT" are the intellectual
 * property of, and protected by Beckhoff Automation GmbH.
 */
#ifndef __CPUINIT_H__
#define __CPUINIT_H__
#include "mbed.h"

extern void cpuinit(void);

//#define SHOE_SERIAL_TX PA_9
//#define SHOE_SERIAL_RX PA_10
#define ET1100_MOSI PTD2
#define ET1100_MISO PTD3
#define ET1100_SCK  PTD1
#define ET1100_SS   PTD0
#define LED_PIN     PTB18
#define ADC_FL      PTB0
#define ADC_FR      PTB2
#define ADC_BL      PTB1
#define ADC_BR      PTB3

extern DigitalOut led;
extern DigitalOut et1100_ss;
extern DigitalIn  et1100_miso;
extern SPI et1100_spi;
extern AnalogIn adcFrontLeft;
extern AnalogIn adcFrontRight;
extern AnalogIn adcBackLeft;
extern AnalogIn adcBackRight;
#endif
